/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.CECDataBlock;
import com.quantumdata.busmon.parser.FiveVoltSenseDataBlock;
import com.quantumdata.busmon.parser.I2CDataBlock;
import com.quantumdata.busmon.parser.Packet;
import com.quantumdata.busmon.parser.TypeConverter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public final class PacketTrace
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int VERSION_MAJOR = 2;
    public static final int VERSION_MINOR = 5;
    private String[] columnNames = new String[]{"Number", "Err", "Time since Boot", "Speed (kHz)", "Dir", "Source", "Type", "Details"};
    private Vector<Packet> packetVector;
    private Vector<Packet> filteredVector;
    private boolean changed;

    public PacketTrace() {
        this.packetVector = new Vector();
        this.filteredVector = new Vector();
        this.clear();
    }

    public PacketTrace(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readInt();
        objectInput.readInt();
        int n = objectInput.readInt();
        Vector<Packet> vector = new Vector<Packet>();
        I2CDataBlock.resetParser();
        CECDataBlock.resetParser();
        for (int i = 0; i < n; ++i) {
            Object object = objectInput.readObject();
            if (!(object instanceof Packet)) {
                JOptionPane.showMessageDialog(Sniffer.window, "Whoa nelly!  Object " + i + " is not a Packet!");
                continue;
            }
            vector.add((Packet)object);
        }
        this.clear();
        this.packetVector = vector;
        this.constructFilteredVector();
        this.fireTableDataChanged();
    }

    public void writeTrace(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(2);
        objectOutput.writeInt(5);
        int n = this.packetVector.size();
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeObject(this.packetVector.get(i));
        }
    }

    public synchronized Packet getPacket(int n) {
        return this.filteredVector.get(n);
    }

    public synchronized void clear() {
        if (this.packetVector != null) {
            this.packetVector.clear();
        }
        if (this.filteredVector != null) {
            this.filteredVector.clear();
        }
        this.packetVector = new Vector();
        this.filteredVector = new Vector();
        this.changed = false;
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Packet packet) {
        PacketTrace packetTrace = this;
        synchronized (packetTrace) {
            this.packetVector.add(packet);
            if (MainAppFrame.togglePauseAction.getValue("actionConstants.selected") == Boolean.FALSE) {
                if (this.filteredVector.size() > 0) {
                    this.addFilteredPacket(this.filteredVector.remove(this.filteredVector.size() - 1));
                }
                this.addFilteredPacket(packet);
            }
            this.changed = true;
            this.fireTableDataChanged();
        }
    }

    public void updateFilteredTrace() {
        this.constructFilteredVector();
    }

    private boolean addFilteredPacket(Packet packet) {
        boolean bl;
        if (!MainAppFrame.togglePedanticAction.isTrue()) {
            if (packet.dataBlock == null) {
                return false;
            }
            if (packet.isI2C() && ((I2CDataBlock)packet.dataBlock).getRawMessage() == null) {
                return false;
            }
            if (packet.isCEC() && ((CECDataBlock)packet.dataBlock).getRawMessage() == null) {
                return false;
            }
        }
        boolean bl2 = (bl = packet.isError()) || !MainAppFrame.errorsOnlyAction.isTrue();
        boolean bl3 = packet.isDDCCI() && MainAppFrame.filterDDCCIAction.isTrue();
        bl3 = bl3 || packet.isEDID() && MainAppFrame.filterEDIDAction.isTrue();
        bl3 = bl3 || packet.isEvent() && MainAppFrame.filterEventsAction.isTrue();
        bl3 = bl3 || packet.isHDCP() && MainAppFrame.filterHDCPAction.isTrue();
        bl3 = bl3 || packet.isCEC() && MainAppFrame.filterCECAction.isTrue();
        boolean bl4 = bl3 = bl3 || packet.isOther() && MainAppFrame.filterOtherAction.isTrue();
        if (bl2 && bl3) {
            this.filteredVector.add(packet);
            return true;
        }
        return false;
    }

    private synchronized void constructFilteredVector() {
        this.filteredVector.clear();
        this.filteredVector = new Vector();
        for (int i = 0; i < this.packetVector.size(); ++i) {
            this.addFilteredPacket(this.packetVector.get(i));
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.filteredVector.size();
    }

    public boolean tableChanged() {
        return this.changed;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        String string;
        String string2 = "";
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (n > this.filteredVector.size()) {
            return null;
        }
        Packet packet = this.filteredVector.get(n);
        block0 : switch (n2) {
            case 0: {
                string = Integer.toString(packet.getOrdinal());
                break;
            }
            case 1: {
                string = packet.isError() ? "!!!" : "";
                break;
            }
            case 2: {
                string = TypeConverter.getTimestampString(packet.getTimestamp());
                break;
            }
            case 3: {
                string = TypeConverter.getSpeedString(packet.getSpeed());
                break;
            }
            case 4: {
                string = packet.getDirection();
                break;
            }
            case 5: {
                switch (packet.getSource()) {
                    case 5: {
                        FiveVoltSenseDataBlock fiveVoltSenseDataBlock = (FiveVoltSenseDataBlock)packet.getDataBlock();
                        string = fiveVoltSenseDataBlock.getSourceName();
                        break block0;
                    }
                }
                string = Packet.getSourceName(packet.getSource());
                break;
            }
            case 6: {
                string = packet.getDescription();
                break;
            }
            case 7: {
                string = packet.getDetails();
                break;
            }
            default: {
                string = "???";
            }
        }
        if (packet.isError()) {
            string2 = "<html><span style='color:#ff0000;'>";
            string3 = "</span></html>";
        } else if (packet.isEDID()) {
            string2 = "<html><span style='color:#808000;'>";
            string3 = "</span></html>";
        } else if (packet.isDDCCI()) {
            string2 = "<html><span style='color:#0000c0;'>";
            string3 = "</span></html>";
        } else if (packet.isHDCP()) {
            string2 = "<html><span style='color:#00c000;'>";
            string3 = "</span></html>";
        } else if (packet.isEvent()) {
            string2 = "<html><span style='color:#008080;'>";
            string3 = "</span></html>";
        } else if (packet.isCEC()) {
            string2 = "<html><span style='color:#c000c0;'>";
            string3 = "</span></html>";
        }
        stringBuffer.append(string2);
        stringBuffer.append(string);
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public int getPacketCount() {
        return this.packetVector.size();
    }

    public int getFilteredCount() {
        return this.filteredVector.size();
    }

    public boolean needsSaving() {
        return this.tableChanged() && 1 == JOptionPane.showConfirmDialog(Sniffer.window, "Current trace has not been saved.  If you continue, any unsaved changes will be lost.  Do you want to proceed?", "Confirm Trace Save", 0, 2);
    }
}

